<?php
session_start();

include_once "dex.php";  // Assure-toi que les vaisseaux sont définis ici

if (!isset($_SESSION['login'])) {
    // Si l'utilisateur n'est pas connecté, rediriger vers la page de connexion
    header("Location: authentification/connexion.php");
    exit();
}

try {
    $host = 'localhost'; 
    $db = 'marwan_starship_showdown';
    $user = 'marwan_trc';  
    $pass = 'pokemonepee1511'; 
    $dsn = "mysql:host=$host;dbname=$db;charset=utf8";

    // Créer une instance PDO
    $pdo = new PDO($dsn, $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Récupérer le login de l'utilisateur connecté
    $login = $_SESSION['login'];

    // Requête pour récupérer la flotte de l'utilisateur
    $stmt = $pdo->prepare("SELECT * FROM flotte WHERE login = :login");
    $stmt->execute(['login' => $login]);
    $flotte = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($flotte) {
        // Récupérer les IDs des vaisseaux
        $vaisseaux = [
            $flotte['vaisseau_1'],
            $flotte['vaisseau_2'],
            $flotte['vaisseau_3'],
            $flotte['vaisseau_4'],
            $flotte['vaisseau_5']
        ];
        
        // Récupérer les détails des vaisseaux à partir de leur ID
        $vaisseauxDetails = [];
        foreach ($vaisseaux as $vaisseauId) {
            if (isset($liste_vaisseaux[$vaisseauId])) {
                $vaisseauxDetails[] = $liste_vaisseaux[$vaisseauId]; 
            }
        }
    } else {
        $vaisseauxDetails = [];  // Aucun vaisseau trouvé
    }

} catch (PDOException $e) {
    echo 'Erreur : ' . $e->getMessage();
    $vaisseauxDetails = [];
}

?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/style.css">
    <title>Page d'Accueil</title>
</head>
<body>
    <div class="wrapper3">
        <div class="home-title">
            <h1>Starship Showdown</h1>
            <div class="home-title-text">
                <p>Starship Showdown est un petit jeu de stratégie au tour par tour. 
                Créez votre propre flotte à partir de nombreux modèles de vaisseaux.</p>
                <p>Chaque vaisseau est capable d'utiliser des capacités basées sur les membres de leur équipage.
                Il vous est possible de lancer un combat contre une flotte ennemie, ou de personnaliser votre équipe.</p>
            </div>
            
        </div>
        <div class="home-menu">
            <p>Login - <strong><?php echo htmlspecialchars($_SESSION['login']); ?></strong></p>
            <form method="POST" action="authentification/deconnexion.php">
                <button type="submit" class="btn-rouge">Déconnexion</button>
            </form>
        </div>
        <div class="home-flotte">
            <h2>Ma Flotte</h2>
            <div class="home-flotte-list">
                <?php if (empty($vaisseauxDetails)): ?>
                    <p>Aucun vaisseau dans votre flotte.</p>
                <?php else: ?>
                    <?php foreach ($vaisseauxDetails as $vaisseau): ?>
                        <div class="home-flotte-vaisseau">
                        <?php echo $vaisseau->showVaisseau();
                            echo $vaisseau->showStats(); ?>
                        </div>

                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
        <div class="lancer-combat">
            <h2>Lancer un combat</h2>
            <?php if (!empty($vaisseauxDetails)): ?>
                <a href="index.php" class="btn-vert">Lancer un combat</a>
            <?php else: ?>
                <p style="color: grey;">Ajoutez des vaisseaux à votre flotte pour lancer un combat.</p>
            <?php endif; ?>
        </div>
        <div class="choisir-flotte">
            <h2>Le H.A.N.G.A.R</h2>
            <a href="choix.php" class="btn-normal">Choisir ma Flotte</a>
            <p style="color: red;">5 membres maximum dans la flotte - Pas de doublons</p>

        </div>
        </div>
    </div>
</body>
</html>
