document.addEventListener("DOMContentLoaded", () => {
    const canvas = document.getElementById("canvas-container");
    console.log(document.getElementById("canvas-container").innerHTML);


    let xOffset = -1000; // Position initiale sur X
    let yOffset = -1000; // Position initiale sur Y
    const moveSpeed = 50; // Vitesse de déplacement

    // Fonction pour déplacer le canvas
    const moveCanvas = (xChange, yChange) => {
        xOffset += xChange;
        yOffset += yChange;

        canvas.style.transform = `translate(${xOffset}px, ${yOffset}px)`;
    };

    // Écoute des touches pour le déplacement
    window.addEventListener("keydown", (e) => {
        switch (e.key) {
            case "ArrowUp":
                moveCanvas(0, moveSpeed);
                break;
            case "ArrowDown":
                moveCanvas(0, -moveSpeed);
                break;
            case "ArrowLeft":
                moveCanvas(moveSpeed, 0);
                break;
            case "ArrowRight":
                moveCanvas(-moveSpeed, 0);
                break;
        }
    });

    // Déplacement à la souris (drag and move)
    let isDragging = false;
    let startX, startY;

    canvas.addEventListener("mousedown", (e) => {
        isDragging = true;
        startX = e.clientX;
        startY = e.clientY;
    });

    window.addEventListener("mousemove", (e) => {
        if (isDragging) {
            const dx = e.clientX - startX;
            const dy = e.clientY - startY;

            moveCanvas(dx, dy);

            startX = e.clientX;
            startY = e.clientY;
        }
    });

    window.addEventListener("mouseup", () => {
        isDragging = false;
    });
});
