<?php
session_start();


// Connexion à la base de données
$host = 'localhost';
$dbname = 'starship_showdown';
$username = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erreur de connexion à la base de données : " . $e->getMessage());
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login = $_POST['login'];
    $mot_de_passe = $_POST['mot_de_passe'];

    // Vérifier si le login est vide ou si le mot de passe est court
    if (empty($login) || strlen($mot_de_passe) < 2) {
        echo "<div class='invalid'>Login ou mot de passe invalide.</div>";
    } else {
        // Vérifier si le login est unique
        $stmt = $pdo->prepare("SELECT id FROM utilisateurs WHERE login = ?");
        $stmt->execute([$login]);

        if ($stmt->rowCount() > 0) {
            echo "<div class='invalid'>Ce login est déjà pris.</div>";
        } else {
            // Hacher le mot de passe et enregistrer l'utilisateur
            $mot_de_passe_hash = password_hash($mot_de_passe, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT INTO utilisateurs (login, mot_de_passe) VALUES (?, ?)");
            $stmt->execute([$login, $mot_de_passe_hash]);

            $_SESSION['login'] = $login;
            
            header("Location: ../accueil.php ");
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="../css/style.css">
    <title>Inscription</title>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Albert+Sans:ital,wght@0,100..900;1,100..900&family=DM+Serif+Text:ital@0;1&family=Geist+Mono:wght@100..900&family=Hanken+Grotesk:ital,wght@0,100..900;1,100..900&family=Source+Serif+4:ital,opsz,wght@0,8..60,200..900;1,8..60,200..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Serif+Text:ital@0;1&family=Geist+Mono:wght@100..900&family=Hanken+Grotesk:ital,wght@0,100..900;1,100..900&family=Source+Serif+4:ital,opsz,wght@0,8..60,200..900;1,8..60,200..900&display=swap" rel="stylesheet">
</head>
<body>
    <div class="no-responsive"></div>
    <div class="bar"></div>
    <div class="wrapper4">
        <div class="logo">
            <img src="../assets/logo.svg" alt="">
            <p>Un “JRPG” web amateur codé en 3 jours,<br>et designé en 4 jours.<br> 
            2025 - développé par zaza. </p>
        </div>

        <div class="form">
            <p class="section-title albert-sans right red">INSCRIPTION</p>
            <form method="POST" action="inscription.php">
                <div class="logins">
                    <div class="login">
                        <label for="login">Nom d'utilisateur</label>
                        <input type="text" name="login" required>
                    </div>
                    <div class="login">
                        <label for="mot_de_passe">Mot de passe</label>
                        <input type="password" name="mot_de_passe" required>
                    </div>
                </div>
                <div class="validation">
                    <button type="submit" class="btn-default">S'inscrire</button>
                    <a href="connexion.php" class="btn-default">Se connecter</a>
                </div>
            </form>
        </div>
    </div>
</body>
</html>
