<?php
session_start();

// Vérifier si l'utilisateur est bien connecté et si les données sont valides
if (isset($_POST['vaisseaux']) && isset($_POST['login']) && is_array(json_decode($_POST['vaisseaux']))) {

    // Récupérer les données de la requête
    $login = $_POST['login'];
    $vaisseaux = json_decode($_POST['vaisseaux']);  // Décoder le tableau de vaisseaux envoyé

    // Informations pour la connexion à la base de données
    $host = 'localhost'; 
    $db = 'starship_showdown';  
    $user = 'root';  
    $pass = ''; 
    $dsn = "mysql:host=$host;dbname=$db;charset=utf8";

    try {
        // Connexion à la base de données
        $pdo = new PDO($dsn, $user, $pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Vérifier que l'utilisateur existe dans la base de données (sécurisation)
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM utilisateurs WHERE login = ?");
        $stmt->execute([$login]);
        $user_exists = $stmt->fetchColumn();

        if ($user_exists > 0) {

            // Supprimer l'ancienne flotte de l'utilisateur
            $stmt = $pdo->prepare("DELETE FROM flotte WHERE login = ?");
            $stmt->execute([$login]);

            // Insérer la nouvelle flotte
            $stmt = $pdo->prepare("INSERT INTO flotte (login, vaisseau_1, vaisseau_2, vaisseau_3, vaisseau_4, vaisseau_5) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->execute([$login, $vaisseaux[0], $vaisseaux[1], $vaisseaux[2], $vaisseaux[3], $vaisseaux[4]]);

            // Réponse de succès
            echo json_encode([
                'success' => true,
                'message' => 'Flotte enregistrée avec succès.'
            ]);
        } else {
            // Si l'utilisateur n'existe pas
            echo json_encode([
                'success' => false,
                'message' => 'Utilisateur non trouvé.'
            ]);
        }

    } catch (PDOException $e) {
        // Gestion des erreurs de la base de données
        echo json_encode([
            'success' => false,
            'message' => 'Erreur de connexion à la base de données : ' . $e->getMessage()
        ]);
    }
} else {
    // Si les données sont invalides ou manquantes
    echo json_encode([
        'success' => false,
        'message' => 'Données invalides.'
    ]);
}
?>
