document.addEventListener("DOMContentLoaded", () => {
    const sectionTitle = document.querySelector(".visite-0"); // Le titre de la section
    const otherElements = document.querySelectorAll(".visite-video, .lines-expo, .element:not(.inspirations-content)"); // Tous les autres éléments sauf inspirations-content
    const inspirationTitle = document.querySelector(".inspirations-title"); // Titre des inspirations
    const inspirationContent = document.querySelector(".inspirations-content"); // Contenu des inspirations

    // Cache les autres éléments au début
    otherElements.forEach(element => {
        element.style.display = "none"; // Cache chaque élément
    });

    // Cache le contenu des inspirations au début
    inspirationContent.style.display = "none";

    // Ajoute un événement pour afficher les autres éléments quand on clique sur le titre de la section
    sectionTitle.addEventListener("click", () => {
        otherElements.forEach(element => {
            element.style.display = "block"; // Affiche chaque élément
            element.style.opacity = 0; // Commence avec une opacité nulle
            element.style.transition = "opacity 0.5s ease-in-out"; // Ajoute une transition
            setTimeout(() => {
                element.style.opacity = 1; // Augmente progressivement l'opacité
            }, 50); // Légère pause pour la transition
        });
    });

    // Ajoute un événement pour afficher le contenu des inspirations quand on clique sur inspirations-title
    inspirationTitle.addEventListener("click", () => {
        inspirationContent.style.display = "block"; // Affiche le contenu des inspirations
        inspirationContent.style.opacity = 0; // Commence avec une opacité nulle
        inspirationContent.style.transition = "opacity 0.5s ease-in-out"; // Ajoute une transition
        setTimeout(() => {
            inspirationContent.style.opacity = 1; // Augmente progressivement l'opacité
        }, 50); // Légère pause pour la transition
    });
});

