<?php
  session_start();

  //Redirection si pas connecté
  if (!isset($_SESSION['admin_user'])) {
    header("Location: admin.php"); 
    exit();
}

  //Connexion à la base de données
  $conn = new mysqli("localhost", "marwan_trc", "pokemonepee1511", "marwan_resa_manga");

  //On récupère toutes les données dont on aura besoin
  $sql = "SELECT client.id_client, client.pseudo, client.email,
          reservation.id_reservation, reservation.date_debut, reservation.date_fin, reservation.date_reservation,
          manga.id_manga, manga.titre, manga.auteur, manga.cover, genre.nom_genre 
          FROM client 
          LEFT JOIN reservation ON client.id_client = reservation.id_client 
          LEFT JOIN reservation_manga ON reservation.id_reservation = reservation_manga.id_reservation 
          LEFT JOIN manga ON reservation_manga.id_manga = manga.id_manga 
          LEFT JOIN genre ON manga.id_genre = genre.id_genre
          ORDER BY client.id_client DESC, reservation.id_reservation DESC;";
  $recup_donnees = $conn->query($sql);


?>



<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="main.css">
  <title>Espace admin - Plume</title>
</head>

<body>

<header>
    <h1>Plume - Backoffice</h1>
    <nav>
      <a href="homepage_admin.php">Mangas</a>
      <a href="clients.php">Clients</a>
      <a href="tableaubord.php">Tableau de bord</a>
      <a href="deconnexion.php" class="deco">Déconnexion</a>
      <p>AdminVanier</p>
    </nav>
  </header>

  <main>
    <h2 class="page-title">Liste des clients</h2>
      <div class="client-container">
        <?php //On affiche les clients

          //On crée une variable qui va indiquer à quel moment on passe à un nouveau client

          
          if ($recup_donnees->num_rows > 0) {
            $cli_act = null;
            $resa_act = null;
            
            while ($col = $recup_donnees->fetch_assoc()) {
              if ($cli_act !== $col['id_client']) {
                if ($cli_act !== null) {
                  if ($resa_act !== null) {
                    echo "      </div>"; 
                    echo "    </div>"; 
                  } 
                  echo "  </div>";
                  echo "</div>"; 
                }
                
                // On actualise la tablie client
                $cli_act = $col['id_client'];
                $resa_act = null; 
                
                // On affiche les informations du client
                echo "<div class='client-card'>";
                echo "  <div class='client-card-header'>";
                echo "      <p class='resa-card-id'> Numéro de client : " . $col['id_client'] . "</p>";
                echo "  </div>";
                echo "  <div class='client-info-container'>"; 
                echo "      <p class='client-card-pseudo'>Pseudo : " . $col['pseudo'] . "</p>";
                echo "      <p class='client-card-email'>Adresse mail : " . $col['email'] . "</p>";
                echo "  </div>";
                echo "  <div class='cd-resa-container'>"; 
              }
              
              if ($resa_act !== $col['id_reservation']) {
                if ($resa_act !== null) {
                  echo "      </div>"; 
                  echo "    </div>"; 
                } 
                
                $resa_act = $col['id_reservation'];
                
                // On affiche les résa
                echo "  <div class='cd-resa-card'>";
                echo "      <p class='cd-resa-id'> Réservation n° " . $col['id_reservation'] . " </p>";
                echo "      <div class='cd-resa-info'>"; // Conteneur pour les informations de la résa
                echo "          <p class='cd-resa-date'> Date de réservation : " . $col['date_reservation'] . " </p>";
                echo "          <p class='cd-resa-date'> Récupère ses mangas à partir du <strong>" . $col['date_debut'] . "</strong> </p>";
                echo "          <p class='cd-resa-date'> Doit les rendre le <strong>" . $col['date_fin'] . "</strong> </p>";
                echo "      </div>";
                echo "      <div class='cd-manga-container'>"; // Conteneur pour les détails du manga
              }
              
              // On termine avec les détails des mangas
              echo "        <div class='cd-manga-card'>";
              echo "          <p class='cd-manga-card-titre'> " . $col['titre'] . " </p>";
              echo "          <p class='cd-manga-card-auteur'> " . $col['auteur'] . " </p>";
              echo "          <img src='" . $col['cover'] . "' width='100%' class='manga-card-cover'>";
              echo "          <p class='cd-manga-card-genre'> " . $col['nom_genre'] . " </p>";
              echo "        </div>";
            }
            
            // Fin de la dernière réservation et du dernier client
            if ($cli_act !== null) {
              if ($resa_act !== null) {
                echo "      </div>"; // Fin du conteneur des mangas
                echo "    </div>"; // Fin de la carte de réservation
              } else {
                // Aucune réservation pour ce client
                echo "<p>Aucune réservation</p>";
              }
              echo "  </div>"; // Fin des informations du client
              echo "</div>"; // Fin de la carte client
            }
          } else {
            echo "<p> Aucun client récupéré. </p>";
          }
          ?>
          
  
      </div>

  </main>

  
</body>
</html>