<?php
session_start();

if (!isset($_SESSION['admin_user'])) {
  header("Location: admin.php");
  exit();
}

$conn = new mysqli("localhost", "marwan_trc", "pokemonepee1511", "marwan_resa_manga");

if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

$sql_fetch_stock = "SELECT id_manga, titre, auteur FROM manga WHERE nb_exemplaires = 0";
$result_fetch_stock = $conn->query($sql_fetch_stock);

$sql_top_dix = "
  SELECT m.id_manga, m.titre, m.auteur, g.nom_genre, COUNT(rm.id_manga) AS nb_resa
  FROM manga AS m
  JOIN reservation_manga AS rm ON m.id_manga = rm.id_manga
  JOIN genre AS g ON m.id_genre = g.id_genre
  GROUP BY rm.id_manga
  ORDER BY nb_resa DESC LIMIT 10;";
$result_top_dix = $conn->query($sql_top_dix);

$sql_stats = "
  SELECT 
    (SELECT COUNT(*) FROM client) AS nb_clients,
    (SELECT COUNT(DISTINCT id_client) FROM reservation) AS nb_clients_reserve,
    (SELECT COUNT(*) FROM manga) AS nb_mangas,
    (SELECT COUNT(*) FROM reservation) AS nb_reservations;";
$result_stats = $conn->query($sql_stats);
$col = $result_stats->fetch_assoc();

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="main.css">
  <title>Espace Admin - Plume</title>
</head>
<body>

<header>
    <h1>Plume - Backoffice</h1>
    <nav>
      <a href="homepage_admin.php">Mangas</a>
      <a href="clients.php">Clients</a>
      <a href="tableaubord.php">Tableau de bord</a>
      <a href="deconnexion.php" class="deco">Déconnexion</a>
      <p>AdminVanier</p>
    </nav>
  </header>

<main>
  <div class="page-title">
    <h2>Statistiques des mangas</h2>
  </div>

  <div class="all-tables">

    <div class="table-container-stock">
      <h3>Mangas écoulés</h3>
      <table>
        <thead>
          <tr>
            <th>Titre</th>
            <th>Auteur</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($result_fetch_stock->num_rows > 0): ?>
            <?php while($row = $result_fetch_stock->fetch_assoc()): ?>
              <tr>
                <td><?php echo $row['titre']; ?></td>
                <td><?php echo $row['auteur']; ?></td>
              </tr>
            <?php endwhile; ?>
          <?php else: ?>
            <tr>
              <td colspan="2">Aucun manga en rupture de stock.</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <div class="table-container-stat">
      <h3>Statistiques annexes</h3>
      <table>
        <tbody>
          <tr>
            <td>Nombre de clients</td>
            <td><?php echo $col['nb_clients']; ?></td>
          </tr>
          <tr>
            <td>Nombre de clients ayant réservé</td>
            <td><?php echo $col['nb_clients_reserve']; ?></td>
          </tr>
          <tr>
            <td>Mangas enregistrés dans Plume</td>
            <td><?php echo $col['nb_mangas']; ?></td>
          </tr>
          <tr>
            <td>Total des réservations effectuées</td>
            <td><?php echo $col['nb_reservations']; ?></td>
          </tr>
        </tbody>
      </table>
    </div>


    <div class="table-container-top">
      <h3>Les dix mangas les plus réservés</h3>
      <table>
        <thead>
          <tr>
            <th>Titre</th>
            <th>Auteur</th>
            <th>Genre</th>
            <th>Nombre de réservations</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($result_top_dix->num_rows > 0): ?>
            <?php while($row = $result_top_dix->fetch_assoc()): ?>
              <tr>
                <td><?php echo $row['titre']; ?></td>
                <td><?php echo $row['auteur']; ?></td>
                <td><?php echo $row['nom_genre']; ?></td>
                <td><?php echo $row['nb_resa']; ?></td>
              </tr>
            <?php endwhile; ?>
          <?php else: ?>
            <tr>
              <td colspan="4">Aucun manga n'a été réservé.</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

  </div>

  
</main>

</body>
</html>
