<?php
session_start();


// Connexion à la base de données
$host = 'localhost';
$dbname = 'marwan_starship_showdown';
$username = 'marwan_trc';
$password = 'pokemonepee1511';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erreur de connexion à la base de données : " . $e->getMessage());
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login = $_POST['login'];
    $mot_de_passe = $_POST['mot_de_passe'];

    // Vérifier si le login est vide ou si le mot de passe est court
    if (empty($login) || strlen($mot_de_passe) < 2) {
        echo "Login ou mot de passe invalide.";
    } else {
        // Vérifier si le login est unique
        $stmt = $pdo->prepare("SELECT id FROM utilisateurs WHERE login = ?");
        $stmt->execute([$login]);

        if ($stmt->rowCount() > 0) {
            echo "Ce login est déjà pris.";
        } else {
            // Hacher le mot de passe et enregistrer l'utilisateur
            $mot_de_passe_hash = password_hash($mot_de_passe, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT INTO utilisateurs (login, mot_de_passe) VALUES (?, ?)");
            $stmt->execute([$login, $mot_de_passe_hash]);

            $_SESSION['login'] = $login;
            
            header("Location: ../accueil.php ");
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="../css/style.css">
    <title>Inscription</title>
</head>
<body>
    <div class="wrapper4">
    <h1>Inscription</h1>
    <form method="POST" action="inscription.php">
        <div class="login">
            <label for="login">Login :</label>
            <input type="text" name="login" required>
        </div>
        <div class="mdp">
            <label for="mot_de_passe">Mot de passe :</label>
            <input type="password" name="mot_de_passe" required>
        </div>
        <button type="submit" class="btn-normal">S'inscrire</button>
    </form>
    <a href="connexion.php">Se connecter</a>
    </div>

</body>
</html>
