<?php
session_start();

// Vérifier si l'utilisateur est connecté (si la variable de session 'login' existe)
if (!isset($_SESSION['login'])) {
    // Si l'utilisateur n'est pas connecté, rediriger vers la page de connexion
    header("Location: authentification/connexion.php");
    exit();
} 

include_once "dex.php"; // Assurez-vous que vos vaisseaux sont définis dans ce fichier.

try {
    $host = 'localhost';
    $db = 'marwan_starship_showdown';
    $user = 'marwan_trc';
    $pass = 'pokemonepee1511';
    $dsn = "mysql:host=$host;dbname=$db;charset=utf8";

    // Créer une instance PDO
    $pdo = new PDO($dsn, $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Récupérer le login de l'utilisateur connecté
    $login = $_SESSION['login'];

    // Requête pour récupérer la flotte de l'utilisateur
    $stmt = $pdo->prepare("SELECT * FROM flotte WHERE login = :login");
    $stmt->execute(['login' => $login]);
    $flotte = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($flotte) {
        // Récupérer les IDs des vaisseaux
        $vaisseaux = [
            $flotte['vaisseau_1'],
            $flotte['vaisseau_2'],
            $flotte['vaisseau_3'],
            $flotte['vaisseau_4'],
            $flotte['vaisseau_5']
        ];

        // Récupérer les détails des vaisseaux à partir de leur ID
        $vaisseauxDetails = [];
        foreach ($vaisseaux as $vaisseauId) {
            if (isset($liste_vaisseaux[$vaisseauId])) {
                $vaisseauxDetails[] = $liste_vaisseaux[$vaisseauId];
            }
        }
    } else {
        $vaisseauxDetails = [];
    }

} catch (PDOException $e) {
    echo 'Erreur : ' . $e->getMessage();
    $vaisseauxDetails = [];
}

?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="css/style.css">
    <title>Vaisseau de Combat</title>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> <!-- Pour faciliter l'utilisation d'AJAX -->
</head>
<body>
    <div class="wrapper2">
    <div class="choix-menu">
            <button id="valider-flotte" class="btn-vert">Valider</button>


        </div>
        <h1 class="choix-title">Le H.A.N.G.A.R</h1>
        <div class="affichage-flotte">
            <?php if (!empty($vaisseauxDetails)): ?>
                <?php foreach ($vaisseauxDetails as $vaisseau): ?>
                    <div class="vaisseau-ajoute" data-id="<?php echo $vaisseau->id; ?>"> 
                        <?php echo $vaisseau->showVaisseau(); ?>
                        <div class="stats" style="display: none;">
                            <?php echo $vaisseau->showStats(); ?>
                        </div>
                        <div class="moveset" style="display: none;">
                            <?php echo $vaisseau->showMoveset(); ?>
                        </div>
                        <div class="liste-vaisseaux-boutons">
                            <button class="btn-normal details">Détails</button>
                            <button class="btn-rouge supprimer">-</button>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <div class="liste-vaisseaux">
            <?php foreach ($liste_vaisseaux as $index => $vaisseau): ?>
                <div class="vaisseau-choix" data-id="<?php echo $index; ?>">
                    <div class="vaisseau-choix-front">
                        <?php echo $vaisseau->showVaisseau(); ?>
                        <div class="stats" style="display: none;">
                            <?php echo $vaisseau->showStats(); ?>
                        </div>
                    </div>
     
                    <div class="moveset" style="display: none;">
                        <?php echo $vaisseau->showMoveset(); ?>
                    </div>
                    <div class="liste-vaisseaux-boutons">
                        <button class="btn-vert ajouter">+</button>
                        <button class="btn-normal details">Détails</button>
                        <button class="btn-rouge supprimer" style="display: none;">-</button>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>


        <div class="detail-vaisseau">
            <!-- Détails du vaisseau sélectionné seront affichés ici -->
        </div>


        <div id="overlay" class="overlay">
            <div class="overlay-content">
                <p id="overlay-message"></p>
                <button id="close-overlay" class="btn-normal">Fermer</button>
            </div>
        </div>  
    </div>

    <script>
$(document).ready(function() {
    function showOverlay(message) {
        $('#overlay-message').text(message);  // Mettre le message dans l'overlay
        $('#overlay').css('display', 'flex');  // Afficher l'overlay
    }

    // Fonction pour fermer l'overlay
    $('#close-overlay').click(function() {
        $('#overlay').css('display', 'none');  // Masquer l'overlay
    });

    const maxVaisseaux = 5;

    // Ajouter un vaisseau à la flotte
    $('.ajouter').click(function() {
        const vaisseauElement = $(this).closest('.vaisseau-choix');
        const vaisseauId = vaisseauElement.data('id');

        // Vérifier si le vaisseau est déjà dans la flotte
        if ($('.affichage-flotte .vaisseau-ajoute[data-id="' + vaisseauId + '"]').length === 0) {
            if ($('.affichage-flotte .vaisseau-ajoute').length < maxVaisseaux) {
                // Copier le vaisseau sélectionné et l'ajouter à la flotte
                const vaisseauHtml = vaisseauElement.html();
                const vaisseauAjoute = $('<div class="vaisseau-ajoute" data-id="' + vaisseauId + '">' + vaisseauHtml + '</div>');
                
                // Ajouter à l'affichage de la flotte
                $('.affichage-flotte').append(vaisseauAjoute);

                vaisseauAjoute.find('.ajouter, .moveset').hide();
                vaisseauAjoute.find('.supprimer').show();
            }
        } else {
            showOverlay('Ce vaisseau est déjà dans votre flotte !');  // Message pour vaisseau déjà ajouté
        }
    });


    // Supprimer un vaisseau de la flotte
    $(document).on('click', '.supprimer', function() {
        $(this).closest('.vaisseau-ajoute').remove();  // Supprimer l'élément de la flotte
    });

    // Afficher les détails du vaisseau
    $(document).on('click', '.details', function() {
        const vaisseauElement = $(this).closest('.vaisseau-choix, .vaisseau-ajoute');
        const vaisseauId = vaisseauElement.data('id');
        
        // Récupérer le HTML sans les boutons (les détails du vaisseau)
        const vaisseauHtml = vaisseauElement.html();
        
        // Récupérer les stats et moveset (en utilisant .show() temporairement pour s'assurer qu'on peut les récupérer)
        const statsHtml = vaisseauElement.find('.stats').show().html();
        const movesetHtml = vaisseauElement.find('.moveset').show().html();
        
        // Ajouter le vaisseau, les stats et le moveset dans la section 'detail-vaisseau'
        $('.detail-vaisseau').html(vaisseauHtml + statsHtml + movesetHtml);
        
        // Cacher les boutons dans la section des détails
        $('.detail-vaisseau').find('.liste-vaisseaux-boutons').hide();
        
        // Remettre les stats et moveset en 'display: none;' après l'ajout dans la section de détail
        vaisseauElement.find('.stats').hide();
        vaisseauElement.find('.moveset').hide();
    });

    $('#valider-flotte').click(function() {
        const vaisseaux = [];
        
        // Collecter tous les vaisseaux existants (ajoutés à la flotte)
        $('.affichage-flotte .vaisseau-ajoute').each(function() {
            vaisseaux.push($(this).data('id'));  // Récupérer les IDs des vaisseaux ajoutés
        });

        // Vérifier qu'il y a 5 vaisseaux
        if (vaisseaux.length === 5) {
            // Envoi des données via AJAX sous forme de JSON pour sauvegarder la flotte
            $.ajax({
                url: 'save_flotte.php',  // URL du fichier PHP pour sauvegarder la flotte
                type: 'POST',
                data: {
                    vaisseaux: JSON.stringify(vaisseaux),  // Convertir les IDs en chaîne JSON
                    login: '<?php echo $_SESSION['login']; ?>'  // Passer le login de l'utilisateur
                },
                dataType: 'json',  // Nous attendons une réponse JSON du serveur
                success: function(response) {
                    if (response.success) {
                        showOverlay('Flotte sauvegardée avec succès !');
                        
                        // Après la sauvegarde de la flotte, envoyer un POST à combat.php pour réinitialiser
                        $.ajax({
                            url: 'combat.php',  // URL du fichier combat.php pour la réinitialisation
                            type: 'POST',
                            data: { reset: true },  // Envoi de la donnée reset à true
                            success: function() {
                                window.location.href = 'accueil.php';  // Rediriger après succès
                            },
                            error: function(xhr, status, error) {
                                console.error(error);
                                showOverlay('Erreur lors de la réinitialisation du combat.');
                            }
                        });
                    } else {
                        showOverlay('Erreur lors de la sauvegarde de la flotte : ' + response.message);
                    }
                },
                error: function(xhr, status, error) {
                    console.error(error);
                    showOverlay('Erreur lors de la sauvegarde de la flotte.');  // Afficher un message d'erreur
                }
            });
        } else {
            showOverlay('Vous devez sélectionner 5 vaisseaux pour valider votre flotte.');  // Vérifier que 5 vaisseaux sont sélectionnés
        }
    });
});

    </script>
</body>
</html>
